/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view.text;

import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import org.openoffice.accessibility.awb.view.text.TextActionDialog;

class TextAttributeDialog
extends TextActionDialog {
    private JCheckBox maBoldCheckBox;
    private JCheckBox maUnderlineCheckBox;
    private JCheckBox maItalicsCheckBox;
    private Color maForeground;
    private Color maBackground;

    public TextAttributeDialog(XAccessibleContext xAccessibleContext) {
        super(xAccessibleContext, "Choose attributes, select text, and press 'Set':", "set");
    }

    protected void Layout() {
        super.Layout();
        this.maForeground = Color.black;
        this.maBackground = Color.white;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.maBoldCheckBox = new JCheckBox("bold");
        this.maUnderlineCheckBox = new JCheckBox("underline");
        this.maItalicsCheckBox = new JCheckBox("italics");
        JButton jButton = new JButton("Foreground", new ColorIcon(true));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextAttributeDialog.this.maForeground = JColorChooser.showDialog(TextAttributeDialog.this, "Select Foreground Color", TextAttributeDialog.this.maForeground);
            }
        });
        JButton jButton2 = new JButton("Background", new ColorIcon(false));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextAttributeDialog.this.maBackground = JColorChooser.showDialog(TextAttributeDialog.this, "Select Background Color", TextAttributeDialog.this.maBackground);
            }
        });
        jPanel.add(this.maBoldCheckBox);
        jPanel.add(this.maUnderlineCheckBox);
        jPanel.add(this.maItalicsCheckBox);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "West");
    }

    boolean EditableTextAction(XAccessibleEditableText xAccessibleEditableText) throws IndexOutOfBoundsException {
        PropertyValue[] propertyValueArray = new PropertyValue[6];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "CharWeight";
        propertyValueArray[0].Value = new Integer(this.maBoldCheckBox.isSelected() ? 150 : 100);
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "CharUnderline";
        propertyValueArray[1].Value = new Integer(this.maUnderlineCheckBox.isSelected() ? 1 : 0);
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "CharBackColor";
        propertyValueArray[2].Value = new Integer(this.maBackground.getRGB());
        propertyValueArray[3] = new PropertyValue();
        propertyValueArray[3].Name = "CharColor";
        propertyValueArray[3].Value = new Integer(this.maForeground.getRGB());
        propertyValueArray[4] = new PropertyValue();
        propertyValueArray[4].Name = "CharPosture";
        propertyValueArray[4].Value = new Integer(this.maItalicsCheckBox.isSelected() ? 1 : 0);
        propertyValueArray[5] = new PropertyValue();
        propertyValueArray[5].Name = "CharBackTransparent";
        propertyValueArray[5].Value = new Boolean(false);
        return xAccessibleEditableText.setAttributes(this.GetSelectionStart(), this.GetSelectionEnd(), propertyValueArray);
    }

    class ColorIcon
    implements Icon {
        private static final int nHeight = 16;
        private static final int nWidth = 16;
        private boolean bForeground;

        public ColorIcon(boolean bl) {
            this.bForeground = bl;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.getColor());
            graphics.fillRect(n, n2, 16, 16);
            graphics.setColor(component.getForeground());
            graphics.drawRect(n, n2, 16, 16);
        }

        Color getColor() {
            if (this.bForeground) {
                return TextAttributeDialog.this.maForeground;
            }
            return TextAttributeDialog.this.maBackground;
        }
    }
}

